//  Implementacja podstawowych obiektw geometrycznych,
//  przydatnych w klasach T3d i TRelatyw3d.
//  Gwnym zadaniem tych klas jest skrcenie zapisu wsprzdnych 3d.
//
#include <vcl\vcl.h>
#pragma hdrstop

#include "geometria.h"
//---------------------------------------------------------------------------
//  Konstruktor domylny
TPunkt :: TPunkt( void)
{
 x = y = z = 0.0;
}
//---------------------------------------------------------------------------
//  Konstruktor inicjujcy
TPunkt :: TPunkt( double Ax, double Ay, double Az)
{
 x = Ax;
 y = Ay;
 z = Az;
}
//---------------------------------------------------------------------------
TPunkt :: TPunkt( const TPunkt &p)
{
 x = p.x;
 y = p.y;
 z = p.z;
}
//---------------------------------------------------------------------------
TPunkt & TPunkt :: operator= (const TPunkt &p)
{
 if( this != &p)
 {
    x = p.x;
    y = p.y;
    z = p.z;
 }
 return *this;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//  Konstruktor domylny
TLinia :: TLinia( void)
{
 x1 = y1 = z1 = x2 = y2 = z2 = 0.0;
}
//---------------------------------------------------------------------------
//  Konstruktor inicjujcy
TLinia :: TLinia( TPunkt p1, TPunkt p2)
{
 x1 = p1.x;
 y1 = p1.y;
 z1 = p1.z;
 x2 = p2.x;
 y2 = p2.y;
 z2 = p2.z;
}
//---------------------------------------------------------------------------
TLinia :: TLinia( const TLinia &l)
{
 x1 = l.x1;
 y1 = l.y1;
 z1 = l.z1;
 x2 = l.x2;
 y2 = l.y2;
 z2 = l.z2;
}
//---------------------------------------------------------------------------
TLinia & TLinia :: operator= (const TLinia &l)
{
 if( this != &l)
 {
    x1 = l.x1;
    y1 = l.y1;
    z1 = l.z1;
    x2 = l.x2;
    y2 = l.y2;
    z2 = l.z2;
 }
 return *this;
}
//---------------------------------------------------------------------------
//  Lini dzielimy na il_podzial odcinkw. Przydatne w TRelatyw3d
TPunkt TLinia :: wylicz_punkt_na_linii( int nr, int il_podzial)
{
 double x, y, z;
 if( il_podzial < 1)
    il_podzial = 1;
 x = x1 + (x2 - x1) / il_podzial * nr;
 y = y1 + (y2 - y1) / il_podzial * nr;
 z = z1 + (z2 - z1) / il_podzial * nr;

 return TPunkt( x, y, z);
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//  Definicja wektora w przestrzeni 3d
//---------------------------------------------------------------------------
//  Konstruktor domylny
TWektor :: TWektor( void)
{
 x = y = z = 0;
}
//---------------------------------------------------------------------------
//  Konstruktor inicjujcy
TWektor :: TWektor( double Ax, double Ay, double Az)
{
 x = Ax;
 y = Ay;
 z = Az;
}
//---------------------------------------------------------------------------
//  Inny konstruktor inicjujcy. Wektor rozpity midzy dwoma punktami.
TWektor :: TWektor( TPunkt poczatek, TPunkt koniec)
{
 x = koniec.x - poczatek.x;
 y = koniec.y - poczatek.y;
 z = koniec.z - poczatek.z;
}
//---------------------------------------------------------------------------
//  Konstruktor kopiujcy
TWektor :: TWektor( const TWektor &w)
{
 x = w.x;
 y = w.y;
 z = w.z;
}
//---------------------------------------------------------------------------
//  Operator przypisania
TWektor & TWektor :: operator= (const TWektor &w)
{
 if( this != &w)
 {
    x = w.x;
    y = w.y;
    z = w.z;
 }
 return *this;
}
//---------------------------------------------------------------------------
//  Uczy dugo wektora = 1
void TWektor :: unormuj( void)
{
 double dlg = sqrt( x*x + y*y + z*z);
 if( dlg > 0)                   //na wszelki wypadek ...
 {
    x /= dlg;
    y /= dlg;
    z /= dlg;
 }
}
//---------------------------------------------------------------------------
